#!/bin/sh
eval 'if [ -x /usr/local/cpanel/3rdparty/bin/perl ]; then exec /usr/local/cpanel/3rdparty/bin/perl -x -- $0 ${1+"$@"}; else exec /usr/bin/perl -x $0 ${1+"$@"}; fi;'    ## no critic qw(ProhibitStringyEval RequireUseStrict) -*-mode:perl-*-
  if 0;

#!/usr/bin/perl
#WHMADDON:addonupdates:kamcf
#ACLS:all

# Copyright cPanel inc

package cgi::kamcf;

use strict;

BEGIN {
    unshift @INC, '/var/cpanel/addons/kamcf/perl', '/usr/local/cpanel';
}

use Whostmgr::ACLS          ();
use Whostmgr::HTMLInterface ();
use Cpanel::Form            ();
use Cpanel::Template        ();
use Cpanel::Encoder::URI    ();
use POSIX                   ();

# from /var/cpanel/addons/kamcf/perl
use Pccc::Email::Kamcf ();

run(@ARGV) unless caller();

sub run {
    _check_acls();
    my $template_file;
    my $form = Cpanel::Form::parseform();

    if ( $form->{'kamcf_configure'} ) {
        _headers("text/html");
        my $install_report = _kamcf_install();

        $template_file =
          -e '/var/cpanel/addons/kamcf/templates/done.tmpl'
          ? '/var/cpanel/addons/kamcf/templates/done.tmpl'
          : '/usr/local/cpanel/whostmgr/docroot/templates/kamcf/done.tmpl';

        Cpanel::Template::process_template(
            'whostmgr',
            {
                'template_file'    => $template_file,
                'email_kamcf_version' => $Pccc::Email::Kamcf::VERSION,
                'email_kamcf_install_report' => "$install_report",
            },
        );
    } else {
        _headers("text/html");

        my $inst = _kamcf_check_installed();

        if ($inst ne 1) {
           $template_file =
            -e '/var/cpanel/addons/kamcf/templates/main.tmpl'
            ? '/var/cpanel/addons/kamcf/templates/main.tmpl'
            : '/usr/local/cpanel/whostmgr/docroot/templates/kamcf/main.tmpl';
        } else {
          $template_file =
            -e '/var/cpanel/addons/kamcf/templates/done.tmpl'
            ? '/var/cpanel/addons/kamcf/templates/done.tmpl'
            : '/usr/local/cpanel/whostmgr/docroot/templates/kamcf/done.tmpl';
        }

        Cpanel::Template::process_template(
            'whostmgr',
            {
                'template_file'    => $template_file,
                'email_kamcf_version' => $Pccc::Email::Kamcf::VERSION,
            },
        );
    }
    return 1;
}

sub _check_acls {
    Whostmgr::ACLS::init_acls();

    if ( !Whostmgr::ACLS::hasroot() ) {
        _headers('text/html');
        Whostmgr::HTMLInterface::defheader('kamcf');
        print <<'EOM';
<br />
<br />
<div align="center"><h1>Permission denied</h1></div>
</body>
</html>
EOM
        exit;
    }
}

sub _headers {
    my $content_type = shift;

    print "Content-type: ${content_type}; charset=utf-8\r\n\r\n";

    return 1;
}

sub _kamcf_check_installed {
  return Pccc::Email::Kamcf::check_installed();
}

sub _kamcf_install {
  return Pccc::Email::Kamcf::install();
}
