package Pccc::Utils::Service;

# Copyright Pccc

=pod

=encoding utf-8

=head1 NAME

Pccc::Utils::Service - service management interface

=head1 SYNOPSYS

        ....

=cut

use strict;

use File::Basename;
use JSON;
use HTTP::Tiny ();
use Pccc::Utils::Api ();

our $VERSION = '0.01';

sub restart {
  my $service = shift;

  my $user  = 'root';
  my $token = Pccc::Utils::Api::get_token;
  my $ua = HTTP::Tiny->new(
    'verify_SSL'      => 0,
    'default_headers' => {
        'Authorization' => "whm $user:$token",
    },
  );

  my $response = $ua->get("https://127.0.0.1:2087/json-api/restartservice?api.version=1&service=$service");
use File::Slurp;
use Data::Dumper;
write_file "/tmp/debug.txt", Dumper $response;
  if ( $response->{'success'} ) {
    my $json = JSON::decode_json( $response->{'content'} );
    return $json->{metadata}->{result};
  } else {
    return 0;
  }
}

1;
