package Pccc::Email::Kamcf;

# Copyright Pccc

=pod

=encoding utf-8

=head1 NAME

Pccc::Email::Kamcf - kamcf configuration plugin

=head1 SYNOPSYS

	Pccc::Email::Kamcf::install();
        ....

=cut

use strict;

use File::Basename;
use File::Copy;
use File::Compare;
use Pccc::Utils::Service;

our $VERSION = '0.02';

sub install {

  my $sadir = "/etc/mail/spamassassin/";
  my $cpsadir = "/usr/local/cpanel/etc/mail/spamassassin/";

  unlink($sadir . "deadweight.cf") if ( -f ($sadir . "deadweight.cf" ) );
  unlink($sadir . "deadweight2.cf") if ( -f ($sadir . "deadweight2.cf" ) );
  unlink($sadir . "deadweight2_meta.cf") if ( -f ($sadir . "deadweight2_meta.cf" ) );
  unlink($sadir . "deadweight2_sub.cf") if ( -f ($sadir . "deadweight2_sub.cf" ) );
  unlink($sadir . "KAM.cf") if ( -f ($sadir . "KAM.cf" ) );
  unlink($sadir . "kam_heavyweights.cf") if ( -f ($sadir . "kam_heavyweights.cf" ) );

  unlink($cpsadir . "deadweight.cf") if ( -f ($cpsadir . "deadweight.cf" ) );
  unlink($cpsadir . "deadweight2.cf") if ( -f ($cpsadir . "deadweight2.cf" ) );
  unlink($cpsadir . "deadweight2_meta.cf") if ( -f ($cpsadir . "deadweight2_meta.cf" ) );
  unlink($cpsadir . "deadweight2_sub.cf") if ( -f ($cpsadir . "deadweight2_sub.cf" ) );
  unlink($cpsadir . "KAM.cf") if ( -f ($cpsadir . "KAM.cf" ) );
  unlink($cpsadir . "kam_heavyweights.cf") if ( -f ($cpsadir . "kam_heavyweights.cf" ) );

  system("/usr/local/cpanel/3rdparty/bin/sa-update --import "  . dirname(__FILE__) . "/conf/kam.sa-channels.mcgrail.com.key");
  if ($? == -1) {
    print "failed to execute: $!\n";
    return $?;
  }
  system("/usr/local/cpanel/3rdparty/bin/sa-update --gpgkey 24C063D8 --channel kam.sa-channels.mcgrail.com");
  if ($? == -1) {
    print "failed to execute: $!\n";
    return $?;
  }
  if (Pccc::Utils::Service::restart("spamd")) {
    if (! -f "/etc/cron.hourly/kamsaupdate.sh" ) {
      copy(dirname(__FILE__) . "/conf/kamsaupdate.sh", "/etc/cron.hourly/kamsaupdate.sh");
      chmod 0755, "/etc/cron.hourly/kamsaupdate.sh";
      return 1;
    }
    # First version had a cron.daily script
    if (compare("/etc/cron.daily/kamsaupdate.sh", "/etc/cron.hourly/kamsaupdate.sh") == 0) {
      unlink("/etc/cron.daily/kamsaupdate.sh");
    }
  }
  return 0;
}

sub check_installed {
  my $res;

  my @kamcf_channel = glob "/var/lib/spamassassin/*/kam_sa-channels_mcgrail_com.cf";

  # Old KAM.cf is installed
  return 2 if ( -f "/etc/mail/spamassassin/KAM.cf" );
  # KAM.cf channel installed
  foreach my $kamfile ( @kamcf_channel ) {
    return 1 if ( -f $kamfile );
  }
  # Not installed
  return 0;
}

1;
