#!/bin/sh
eval 'if [ -x /usr/local/cpanel/3rdparty/bin/perl ]; then exec /usr/local/cpanel/3rdparty/bin/perl -x -- $0 ${1+"$@"}; else exec /usr/bin/perl -x $0 ${1+"$@"}; fi;'    ## no critic qw(ProhibitStringyEval RequireUseStrict) -*-mode:perl-*-
  if 0;

#!/usr/bin/perl
#WHMADDON:addonupdates:fail2ban
#ACLS:all

# Copyright cPanel inc

package cgi::fail2ban;

use strict;

BEGIN {
    unshift @INC, '/var/cpanel/addons/fail2ban/perl', '/usr/local/cpanel';
}

use Whostmgr::ACLS          ();
use Whostmgr::HTMLInterface ();
use Cpanel::Form            ();
use Cpanel::Template        ();
use Cpanel::Encoder::URI    ();
use POSIX                   ();

# from /var/cpanel/addons/fail2ban/perl
use Pccc::Security::Fail2ban ();

run(@ARGV) unless caller();

sub run {
    _check_acls();
    my $template_file;
    my $form = Cpanel::Form::parseform();

    if ( $form->{'f2b_configure'} ) {
        _headers("text/html");
        my $install_report = _f2b_install();
	my $config_report = _f2b_setup($form->{'bad_act'});
	if($config_report eq "") {
	  $config_report = "There was an error while configuring Fail2ban";
	}

        $template_file =
          -e '/var/cpanel/addons/fail2ban/templates/done.tmpl'
          ? '/var/cpanel/addons/fail2ban/templates/done.tmpl'
          : '/usr/local/cpanel/whostmgr/docroot/templates/fail2ban/done.tmpl';

        Cpanel::Template::process_template(
            'whostmgr',
            {
                'template_file'    => $template_file,
                'security_fail2ban_version' => $Pccc::Security::Fail2ban::VERSION,
                'security_fail2ban_install_report' => "$install_report",
                'security_fail2ban_config_report' => "$config_report",
            },
        );
    } else {
        _headers("text/html");

        my $inst = _f2b_check_installed();

        if ($inst eq 0) {
           $template_file =
            -e '/var/cpanel/addons/fail2ban/templates/main.tmpl'
            ? '/var/cpanel/addons/fail2ban/templates/main.tmpl'
            : '/usr/local/cpanel/whostmgr/docroot/templates/fail2ban/main.tmpl';
        } else {
          $template_file =
            -e '/var/cpanel/addons/fail2ban/templates/done.tmpl'
            ? '/var/cpanel/addons/fail2ban/templates/done.tmpl'
            : '/usr/local/cpanel/whostmgr/docroot/templates/fail2ban/done.tmpl';
        }

        Cpanel::Template::process_template(
            'whostmgr',
            {
                'template_file'    => $template_file,
                'security_fail2ban_version' => $Pccc::Security::Fail2ban::VERSION,
            },
        );
    }
    return 1;
}

sub _check_acls {
    Whostmgr::ACLS::init_acls();

    if ( !Whostmgr::ACLS::hasroot() ) {
        _headers('text/html');
        Whostmgr::HTMLInterface::defheader('fail2ban');
        print <<'EOM';
<br />
<br />
<div align="center"><h1>Permission denied</h1></div>
</body>
</html>
EOM
        exit;
    }
}

sub _headers {
    my $content_type = shift;

    print "Content-type: ${content_type}; charset=utf-8\r\n\r\n";

    return 1;
}

sub _f2b_check_installed {
  return Pccc::Security::Fail2ban::check_installed();
}

sub _f2b_install {
  return Pccc::Security::Fail2ban::install();
}

sub _f2b_setup {
  my $opts = shift;

  return Pccc::Security::Fail2ban::setup($opts);
}
