package Pccc::Security::Fail2ban;

# Copyright cPanel inc

=pod

=encoding utf-8

=head1 NAME

Pccc::Security::Fail2ban - fail2ban configuration plugin

=head1 SYNOPSYS

	Pccc::Security::Fail2ban::install();
	Pccc::Security::Fail2ban::setup($opts);
        ....

=cut

use strict;

use File::Copy;

our $VERSION = '0.02';

sub install {
  my $res;

  $res = qx{/bin/yum -y install epel-release};
  $res .= qx{/bin/yum-config-manager -y --disable epel};
  $res .= qx{/bin/yum -y install --enablerepo=epel fail2ban fail2ban-firewalld fail2ban-systemd};
  return $res;
}

sub setup {
  my $opts = shift;

  my $res;
 
  # XXX use FindBin to detect the correct path ?
  copy("/var/cpanel/addons/fail2ban/perl/Pccc/Security/conf/filter.d/sshd.conf", "/etc/fail2ban/filter.d/sshd.conf");
  copy("/var/cpanel/addons/fail2ban/perl/Pccc/Security/conf/filter.d/sshd-ddos.conf", "/etc/fail2ban/filter.d/sshd-ddos.conf");
  copy("/var/cpanel/addons/fail2ban/perl/Pccc/Security/conf/filter.d/sshd-aggressive.conf", "/etc/fail2ban/filter.d/sshd-aggressive.conf");
  # if elk4hive is enabled
  if($opts eq 1) {
    copy("/var/cpanel/addons/fail2ban/perl/Pccc/Security/conf/action.d/elk4hive.conf", "/etc/fail2ban/action.d/elk4hive.conf");
    copy("/var/cpanel/addons/fail2ban/perl/Pccc/Security/conf/jail.d/90-sshd-elk4hive.conf", "/etc/fail2ban/jail.d/90-sshd.conf");
  } else {
    copy("/var/cpanel/addons/fail2ban/perl/Pccc/Security/conf/jail.d/90-sshd.conf", "/etc/fail2ban/jail.d/90-sshd.conf");
  }
  $res = qx{/bin/systemctl enable fail2ban 2>&1};
  $res .= qx{/sbin/service fail2ban start 2>&1};
  return $res;
}

sub check_installed {
  my $res;

  $res = qx{/bin/rpm -qa};
  if ( $res =~ /fail2ban\-[0-9]+/ ) {
    return 1;
  } else {
    return 0;
  }
}

1;
