#!/bin/sh
eval 'if [ -x /usr/local/cpanel/3rdparty/bin/perl ]; then exec /usr/local/cpanel/3rdparty/bin/perl -x -- $0 ${1+"$@"}; else exec /usr/bin/perl -x $0 ${1+"$@"}; fi;'    ## no critic qw(ProhibitStringyEval RequireUseStrict) -*-mode:perl-*-
  if 0;

#!/usr/bin/perl
#WHMADDON:addonupdates:example
#ACLS:all

# Copyright Pccc

package cgi::example;

use strict;

BEGIN {
    unshift @INC, '/var/cpanel/addons/example/perl', '/usr/local/cpanel';
}

use Whostmgr::ACLS          ();
use Whostmgr::HTMLInterface ();
use Cpanel::Form            ();
use Cpanel::Template        ();
use Cpanel::Encoder::URI    ();
use Whostmgr::TweakSettings ();
use POSIX                   ();
  
# from /var/cpanel/addons/example/perl
use Pccc::Utils::Example ();

run(@ARGV) unless caller();

sub run {
    _check_acls();
    my $template_file;
    my $form = Cpanel::Form::parseform();

    if ( $form->{'send'} eq 1 ) {
        _headers("text/html");
        my $send_email = _send_email($form->{mailto});

        $template_file =
          -e '/var/cpanel/addons/example/templates/email.tmpl'
          ? '/var/cpanel/addons/example/templates/email.tmpl'
          : '/usr/local/cpanel/whostmgr/docroot/templates/example/email.tmpl';

        Cpanel::Template::process_template(
            'whostmgr',
            {
                'template_file'    => $template_file,
                'utils_example_version' => $Pccc::Utils::Example::VERSION,
                'utils_example_send_email' => "$send_email",
            },
        );
    } elsif ( $form->{'dom'} eq 1 ) {
        _headers("text/html");

        my $token = Pccc::Utils::Example::get_token();
        my $domain = Pccc::Utils::Example::get_domain($form->{'account'});

        $domain = "not found" if not defined $domain;

        $template_file =
          -e '/var/cpanel/addons/example/templates/dom.tmpl'
          ? '/var/cpanel/addons/example/templates/dom.tmpl'
          : '/usr/local/cpanel/whostmgr/docroot/templates/example/dom.tmpl';

        Cpanel::Template::process_template(
            'whostmgr',
            {
                'template_file'    => $template_file,
                'utils_example_version' => $Pccc::Utils::Example::VERSION,
                'utils_example_account' => "$form->{'account'}",
                'utils_example_domain' => "$domain",
            },
        );
    } elsif ( $form->{'setquota'} eq 1 ) {
        _headers("text/html");

        my $token = Pccc::Utils::Example::get_token();
        my $quota;
        if(Pccc::Utils::Example::set_mail_quota($form->{'account'}, $form->{'email'}, $form->{'quota'})) {
          $quota = $form->{'quota'} . "Mb";
        } else {
          $quota = "not changed";
        }

        $template_file =
          -e '/var/cpanel/addons/example/templates/quota.tmpl'
          ? '/var/cpanel/addons/example/templates/quota.tmpl'
          : '/usr/local/cpanel/whostmgr/docroot/templates/example/quota.tmpl';

        Cpanel::Template::process_template(
            'whostmgr',
            {
                'template_file'    => $template_file,
                'utils_example_version' => $Pccc::Utils::Example::VERSION,
                'utils_example_email' => "$form->{'email'}",
                'utils_example_quota' => "$quota",
            },
        );
    } else {
        _headers("text/html");

        $template_file =
          -e '/var/cpanel/addons/example/templates/main.tmpl'
          ? '/var/cpanel/addons/example/templates/main.tmpl'
          : '/usr/local/cpanel/whostmgr/docroot/templates/example/main.tmpl';

        my $token = Pccc::Utils::Example::get_token();
        my $serverip = Pccc::Utils::Example::get_server_ip();
        my $mailquota = Pccc::Utils::Example::get_mail_quota("smarthost", 'smarthost@test.pccc.com');

        Cpanel::Template::process_template(
            'whostmgr',
            {
                'template_file'    => $template_file,
                'utils_example_version' => $Pccc::Utils::Example::VERSION,
                'utils_example_token' => $token,
                'utils_example_ip' => $serverip,
                'utils_example_quota' => $mailquota,
            },
        );
    }
    return 1;
}

sub _check_acls {
    Whostmgr::ACLS::init_acls();

    if ( !Whostmgr::ACLS::hasroot() ) {
        _headers('text/html');
        Whostmgr::HTMLInterface::defheader('example');
        print <<'EOM';
<br />
<br />
<div align="center"><h1>Permission denied</h1></div>
</body>
</html>
EOM
        exit;
    }
}

sub _headers {
    my $content_type = shift;

    print "Content-type: ${content_type}; charset=utf-8\r\n\r\n";

    return 1;
}

sub _send_email {
  my $to = shift;

  return Pccc::Utils::Example::sendmail($to);
}
