package Pccc::Utils::Example;

# Copyright Pccc

=pod

=encoding utf-8

=head1 NAME

Pccc::Utils::Example - example WHM plugin

=head1 SYNOPSYS

	Pccc::Utils::Example::sendmail();
        ....

=cut

use strict;

use File::Basename;
use MIME::Lite;
use JSON;
use Sys::Hostname;
use HTTP::Tiny ();

our $VERSION = '0.01';

sub sendmail {
  my $to = shift;

  my $from = "noreply\@" . hostname;

  my $msg = MIME::Lite->new(
                     From     => $from,
                     To       => $to,
                     Subject  => "Email from WHM",
                     Data     => "Test email",
                     );
  if($msg->send) {
    return "Email sent";
  } else {
    return "Error when sending email";
  }
}

sub get_token {
  my $filename = dirname (__FILE__) . "/token.json";

  my $json_text = do {
    open(my $json_fh, "<:encoding(UTF-8)", $filename)
    or die("Can't open $filename\": $!\n");
    local $/;
    <$json_fh>
  };
  my $json = JSON->new;
  my $data = $json->decode($json_text);
  return $data->{data}->{token} if defined $data;
  return undef;
}

sub get_server_ip {

  my $user  = 'root';
  my $token = get_token;
  my $ua = HTTP::Tiny->new(
    'verify_SSL'      => 0,
    'default_headers' => {
        'Authorization' => "whm $user:$token",
    },
  );

  my $response = $ua->get("https://127.0.0.1:2087/json-api/listips?api.version=1");
  if ( $response->{'success'} ) {
    my $json = JSON::decode_json( $response->{'content'} );
    return "\t$_\n" for map { $_->{'ip'} } @{ $json->{'data'}->{'ip'} };
  } else {
    return undef;
  }
}

sub get_domain {
  my $account = shift;

  return undef if not defined $account;

  my $user  = 'root';
  my $token = get_token;
  my $ua = HTTP::Tiny->new(
    'verify_SSL'      => 0,
    'default_headers' => {
        'Authorization' => "whm $user:$token",
    },
  );

  my $response = $ua->get("https://127.0.0.1:2087/json-api/uapi_cpanel?api.version=1&cpanel.module=DomainInfo&cpanel.function=list_domains&cpanel.user=$account");
  if ( $response->{'success'} ) {
    my $json = JSON::decode_json( $response->{'content'} );
    return $json->{'data'}->{'uapi'}->{'data'}->{'main_domain'};
  } else {
    return undef;
  }
}

sub get_mail_quota {
  my $account = shift;
  my $email = shift;

  my @mail = split /\@/, $email;

  return undef if not defined $email;

  my $user  = 'root';
  my $token = get_token;
  my $ua = HTTP::Tiny->new(
    'verify_SSL'      => 0,
    'default_headers' => {
        'Authorization' => "whm $user:$token",
    },
  );

  my $response = $ua->get("https://127.0.0.1:2087/json-api/uapi_cpanel?api.version=1&cpanel.module=Email&cpanel.function=get_pop_quota&cpanel.user=$account&email=$mail[0]&domain=$mail[1]");
  if ( $response->{'success'} ) {
    my $json = JSON::decode_json( $response->{'content'} );
    return $json->{'data'}->{'uapi'}->{'data'} + 0;
  } else {
    return undef;
  }
}

sub set_mail_quota {
  my $account = shift;
  my $email = shift;
  my $quota = shift;

  my @mail = split /\@/, $email;

  return undef if not defined $email;
  return undef if not defined $quota;

  my $user  = 'root';
  my $token = get_token;
  my $ua = HTTP::Tiny->new(
    'verify_SSL'      => 0,
    'default_headers' => {
        'Authorization' => "whm $user:$token",
    },
  );

  my $response = $ua->get("https://127.0.0.1:2087/json-api/uapi_cpanel?api.version=1&cpanel.module=Email&cpanel.function=edit_pop_quota&cpanel.user=$account&email=$mail[0]&domain=$mail[1]&quota=$quota");
  if ( $response->{'success'} ) {
    my $json = JSON::decode_json( $response->{'content'} );
    return $json->{'data'}->{'uapi'}->{'status'};
  } else {
    return undef;
  }
}
1;
